(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7005,        250]*)
(*NotebookOutlinePosition[     11159,        395]*)
(*  CellTagsIndexPosition[     11085,        389]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Welcome to ",
    FontWeight->"Bold",
    FontColor->GrayLevel[1]],
  StyleBox["MathReader",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->GrayLevel[1]],
  StyleBox["\[RegisteredTrademark]",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[1]],
  "  "
}], "Title",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  CellHorizontalScrolling->True,
  CellFrameMargins->{{16, 16}, {4, 20}},
  FontSize->30,
  Background->RGBColor[0.900008, 0, 0]],

Cell[TextData[{
  StyleBox["A reader for ",
    FontColor->GrayLevel[1]],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontColor->GrayLevel[1]],
  StyleBox["-compatible notebook documents",
    FontColor->GrayLevel[1]]
}], "Subtitle",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {8, 0}},
  CellHorizontalScrolling->True,
  CellFrameMargins->{{18, 16}, {8, 8}},
  FontSize->15,
  Background->RGBColor[0.2, 0, 0.500008]],

Cell[TextData[{
  "This document is an example of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook. Choose the Help menu or click on the links below to see other \
examples."
}], "Text",
  ShowCellBracket->False,
  CellMargins->{{30, 40}, {4, 8}},
  CellHorizontalScrolling->True,
  ParagraphSpacing->{0.8, 0}],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\[Bullet] ",
    FontColor->RGBColor[0, 0, 1]],
  ButtonBox["Using MathReader",
    ButtonData:>{"What is MathReader"},
    ButtonStyle->"GettingStartedLink"],
  "\n",
  StyleBox["\[Bullet] ",
    FontColor->RGBColor[0, 0, 1]],
  ButtonBox["More Information",
    ButtonData:>{"More Information"},
    ButtonStyle->"GettingStartedLink"],
  "\n",
  StyleBox["\[Bullet] ",
    FontColor->RGBColor[0, 0, 1]],
  ButtonBox["Licensing Information",
    ButtonData:>{"Licensing Information"},
    ButtonStyle->"GettingStartedLink"],
  "\n",
  StyleBox["\[Bullet] ",
    FontColor->RGBColor[0, 0, 1]],
  ButtonBox["Resources on the Web",
    ButtonData:>"World Wide Web",
    ButtonStyle->"OtherInformationLink"],
  "\n",
  StyleBox["\[Bullet] ",
    FontColor->RGBColor[0, 0, 1]],
  ButtonBox["The Complete Mathematica System",
    ButtonData:>"complete",
    ButtonStyle->"Hyperlink"]
}], "Text",
  ShowCellBracket->False,
  CellMargins->{{30, 30}, {4, 8}},
  CellHorizontalScrolling->True,
  FontSize->14],

Cell[CellGroupData[{

Cell[TextData[{
  "To obtain your own copy of the complete ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " system, contact Wolfram Research at any of the following addresses:"
}], "Subsubsection",
  CellDingbat->None,
  CellMargins->{{30, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Plain",
  FontSlant->"Italic",
  CellTags->"complete"],

Cell[TextData[{
  StyleBox["Wolfram Research, Inc.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.com",
    ButtonData:>{
      URL[ "mailto:info@wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "  \n",
  StyleBox["web:",
    FontSlant->"Italic"],
  " ",
  ButtonBox["http://www.wolfram.com",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["phone: ",
    FontSlant->"Italic"],
  "217-398-5151\n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " 217-398-1108\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " 100 Trade Center Drive\nChampaign, IL 61820-7237, USA\n\n",
  StyleBox["Wolfram Research Europe Ltd.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.co.uk",
    ButtonData:>{
      URL[ "mailto:info@wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["web:",
    FontSlant->"Italic"],
  " ",
  ButtonBox["http://www.wolfram.co.uk",
    ButtonData:>{
      URL[ "http://www.wolfram.co.uk"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["phone:",
    FontSlant->"Italic"],
  " +44-(0)1993-883400 \n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " +44-(0)1993-883800\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " 10 Blenheim Office Park, Lower Road \nLong Hanborough, Oxfordshire OX8 \
8LN, UK\n\n",
  StyleBox["Wolfram Research Asia Ltd.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["email:",
    FontSlant->"Italic"],
  ButtonBox[" info@wolfram.co.jp",
    ButtonData:>{
      URL[ "mailto:info@wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["web:",
    FontSlant->"Italic"],
  ButtonBox[" http://www.wolfram.co.jp",
    ButtonData:>{
      URL[ "http://www.wolfram.co.jp"], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->None],
  "\n",
  StyleBox["phone:",
    FontSlant->"Italic"],
  " +81-(0)3-5276-0506\n",
  StyleBox["fax:",
    FontSlant->"Italic"],
  " +81-(0)3-5276-0509\n",
  StyleBox["mail:",
    FontSlant->"Italic"],
  " Izumi Building 8F\n3-2-15 Misaki-cho\nChiyoda-ku, Tokyo 101, JAPAN"
}], "SmallText",
  CellMargins->{{30, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  AutoSpacing->False,
  FontSize->10,
  CellTags->"complete"]
}, Open  ]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1152}, {0, 850}},
Editable->False,
CellGrouping->Manual,
WindowSize->{509, 285},
WindowMargins->{{9, Automatic}, {Automatic, 6}},
WindowTitle->None,
ShowCellBracket->True,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathReaderLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MathReader", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MathReaderLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Open  ]]
  }, Open  ]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00<0001804P000000]X2:?oQon82n@960dL5:0?l0080001804P000000]X2:001
0000I00000400@4100000BL?00400@00000000000000000201T1T0000000@000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "complete"->{
    Cell[4076, 138, 432, 13, 62, "Subsubsection",
      CellTags->"complete"],
    Cell[4511, 153, 2466, 93, 372, "SmallText",
      CellTags->"complete"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"complete", 10903, 380}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 518, 19, 59, "Title"],
Cell[2230, 70, 434, 14, 43, "Subtitle"],
Cell[2667, 86, 331, 10, 47, "Text"],

Cell[CellGroupData[{
Cell[3023, 100, 1028, 34, 107, "Text"],

Cell[CellGroupData[{
Cell[4076, 138, 432, 13, 62, "Subsubsection",
  CellTags->"complete"],
Cell[4511, 153, 2466, 93, 372, "SmallText",
  CellTags->"complete"]
}, Open  ]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

